﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Ksiega" %>
<script runat="server">

	public class Confirmation: ContextBase {
	
		public Confirmation(Context context): base(context) {
		}
		
		bool confirm = false;
		[Caption("Wykonać przeliczenie")]
		public bool Confirm {
			get { return confirm; }
			set { 
				confirm = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}

	Confirmation pars;
	[Context]
	public Confirmation Pars {
		get { return pars; }
		set { pars = value; }
	}

    void dc_ContextLoad(Object sender, EventArgs e) {
		if (!pars.Confirm)		
			throw new Exception("Anulowano przeliczenie");
			
		Log progress = new Log();
		Log log = new Log("TOOLS", true);
		
		Row[] rows = (Row[])dc[typeof(Row[])];
		int c = rows.Length;
		int i = 0;
		ZapisElementuKsiegowalnego worker = new ZapisElementuKsiegowalnego();		
		Database database = dc.Session.Login.Database;
    MsSqlDatabase mssql = database as MsSqlDatabase;
    try {
      if (mssql != null)
        mssql.ExecuteCommand(ExecuteMode.WorkDB, "EXECUTE dbo.OpenSession");
      foreach (RozrachunekIdx idx in rows) {
        progress.WriteLine(new Percent((decimal)++i / c));
        Zaplata zap = idx.Dokument as Zaplata;
        Platnosc plat = idx.Dokument as Platnosc;

        if (zap != null && zap.Rozliczana) {
          if (zap.Rozliczenia.Count != 0) {
            log.WriteLine("Zapłata " + zap + " posiada rozliczenia");
            continue;
          }
          worker.Element = zap;
          if (worker.Konto != "") {
            log.WriteLine("Zapłata " + zap + " jest zaksięgowana na konto " + worker.Konto);
            continue;
          }
          string cmd = string.Format("update Zaplaty set Rozliczana = 0, DataRozliczenia = DataDokumentu where id = {0}; ", zap.ID);
          cmd += string.Format("delete from RozrachunkiIdx where DokumentType = 'Zaplaty' and Dokument = {0}", zap.ID);
          database.ExecuteCommand(Soneta.Business.App.ExecuteMode.WorkDB, cmd);
        }

        if (plat != null && plat.Rozliczana) {
          if (plat.Rozliczenia.Count != 0) {
            log.WriteLine("Płatność " + plat + " posiada rozliczenia");
            continue;
          }
          if (!plat.PozycjePrzelewu.IsEmpty) {
            log.WriteLine("Płatność " + plat + " posiada pozycje przelewów");
            continue;
          }
          worker.Element = plat;
          if (worker.Konto != "") {
            log.WriteLine("Płatność " + plat + " jest zaksięgowana na konto " + worker.Konto);
            continue;
          }
          string cmd = string.Format("update Platnosci set Rozliczana = 0, DataRozliczenia = DataDokumentu where id = {0}; ", plat.ID);
          cmd += string.Format("delete from RozrachunkiIdx where DokumentType = 'Platnosci' and Dokument = {0}", plat.ID);
          database.ExecuteCommand(Soneta.Business.App.ExecuteMode.WorkDB, cmd);
        }
      }
    } finally {
      if (mssql != null)
        mssql.ExecuteCommand(ExecuteMode.WorkDB, "EXECUTE dbo.CloseSession");      
    }
    
		
		throw new CancelException();
    }
    
	static void Msg(object value) {
	}    

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Tools</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    </form>
</body>
</html>
